# Voice Transformation Application - Design Guidelines

## Design Approach
**System-Based Approach**: Material Design with influences from professional audio tools (Audacity, Adobe Audition) and modern productivity interfaces (Linear, Vercel). Focus on clarity, technical precision, and efficient workflow.

## Core Design Principles
1. **Technical Transparency**: Make audio processing visible and understandable
2. **Dual-Context Clarity**: Always distinguish between source and target files
3. **Progressive Disclosure**: Show complexity only when needed
4. **Confidence Through Feedback**: Every action provides clear status

---

## Typography
- **Primary Font**: Inter (Google Fonts)
- **Monospace**: JetBrains Mono for technical data
- **Hierarchy**:
  - Page Title: text-3xl font-bold
  - Section Headers: text-xl font-semibold
  - File Names: text-lg font-medium
  - Parameters/Labels: text-sm font-medium
  - Technical Data: text-sm font-mono
  - Helper Text: text-xs text-gray-600

## Layout System
**Spacing Primitives**: Tailwind units of 2, 4, 6, 8, 12, 16
- Component padding: p-6 or p-8
- Section gaps: gap-8 or gap-12
- Card spacing: p-6
- Button padding: px-6 py-3

**Grid Structure**: Single-column workflow with clear stages, max-w-6xl container

---

## Component Library

### 1. File Upload Zones (Dual Interface)
- **Source File Upload** (Left/Top)
  - Large drag-drop area (min-h-48)
  - Dashed border when empty, solid when file loaded
  - Icon: music note or waveform icon (Heroicons)
  - Label: "Source Voice (Template)"
  - File name display with size/duration
  - Remove button when file present

- **Target File Upload** (Right/Bottom)
  - Mirror layout of source
  - Label: "Target Voice (To Transform)"
  - Visual distinction through subtle badge or icon color

### 2. Waveform Visualization Cards
Three distinct waveform displays:
- **Source Waveform**: Visual reference for original voice
- **Target Waveform**: Before transformation
- **Result Waveform**: After transformation (appears after processing)

Each card includes:
- Canvas element for waveform (h-32)
- Playback controls: play/pause, scrubber, timestamp
- Volume slider
- Download button (for result only)

### 3. Parameter Analysis Panel
Collapsible section showing extracted parameters:
- Grid layout (grid-cols-2 md:grid-cols-3)
- Each parameter as a card with:
  - Parameter name (font-medium)
  - Extracted value (font-mono)
  - Visual indicator (progress bar or sparkline)
- Parameters: Pitch, Formants, Spectral Envelope, Timbre, Harmonics, Prosody

### 4. Processing Pipeline
Vertical stepper showing transformation stages:
- Step indicators with icons
- Current step highlighted
- Progress percentage for active step
- Status indicators: pending, processing, complete, error

### 5. Action Controls
- **Transform Button**: Primary CTA (large, prominent)
  - Disabled until both files uploaded
  - Shows processing state with spinner
- **Reset Button**: Secondary action to clear all
- **Advanced Settings Toggle**: Opens technical parameters (optional adjustments)

### 6. Comparison Player
Side-by-side audio player after transformation:
- Three columns: Source | Target | Result
- Synchronized playback option
- A/B comparison toggle
- Visual waveform sync indicators

---

## Navigation & Header
- Minimal top bar with app name/logo
- Optional: GitHub link, documentation link
- No traditional navigation needed (single-purpose tool)

---

## Animations
**Minimal & Purposeful**:
- File upload: gentle scale-in when file loaded
- Waveform: smooth draw animation on load
- Progress: smooth percentage transitions
- State changes: 200ms ease transitions
- NO scroll animations or decorative effects

---

## Icons
**Heroicons** (CDN):
- Upload: cloud-arrow-up
- Play/Pause: play/pause
- Download: arrow-down-tray
- Settings: cog-6-tooth
- Waveform: chart-bar
- Check: check-circle (for completed steps)
- Processing: arrow-path (spinning)

---

## Images
**No hero images** - This is a functional tool, not a marketing page. Focus on interface clarity and technical visualization through waveforms and data displays.

---

## Accessibility
- All file inputs keyboard accessible
- Clear focus states on all interactive elements
- ARIA labels for waveform visualizations
- Status announcements for screen readers during processing
- Keyboard shortcuts for playback (spacebar, arrow keys)

---

## Responsive Strategy
- Desktop (lg+): Side-by-side source/target uploads, three-column waveforms
- Tablet (md): Stacked uploads, two-column parameter grid
- Mobile: Full vertical stack, simplified waveform displays