# VoiceForge Deployment Guide

## Quick Start (One-Command Installation)

Upload the VoiceForge package to your server and run:

```bash
cd voiceforge
sudo bash deploy/install.sh
```

That's it! The application will be available at `http://your-server-ip:5000`

---

## System Requirements

- **Operating System**: Ubuntu 18.04+, Debian 10+, CentOS 7+, RHEL 7+, Rocky Linux, AlmaLinux
- **RAM**: Minimum 1GB, Recommended 2GB+
- **Disk Space**: Minimum 500MB
- **Network**: Open port 5000 (or your configured port)

---

## Installation Options

### Option 1: Automatic Installation (Recommended)

```bash
# Extract the package
unzip voiceforge-deploy.zip
cd voiceforge

# Run installer as root
sudo bash deploy/install.sh
```

The installer will automatically:
- Install FFmpeg (for audio processing)
- Install Node.js 20.x
- Create a dedicated service user
- Build the application
- Create and start a systemd service
- Configure auto-start on boot

### Option 2: Custom Port

```bash
# Install with custom port
PORT=8080 sudo bash deploy/install.sh
```

---

## Managing the Application

### Check Status
```bash
sudo systemctl status voiceforge
```

### View Logs
```bash
# Live logs
sudo journalctl -u voiceforge -f

# Last 100 lines
sudo journalctl -u voiceforge -n 100
```

### Restart Service
```bash
sudo systemctl restart voiceforge
```

### Stop Service
```bash
sudo systemctl stop voiceforge
```

### Start Service
```bash
sudo systemctl start voiceforge
```

---

## Updating the Application

When you have a new version:

```bash
# Extract new package
unzip voiceforge-deploy-v2.zip
cd voiceforge

# Run update script
sudo bash deploy/update.sh
```

The update script will:
- Create a backup of the current installation
- Update application files
- Rebuild the application
- Restart the service
- Automatically rollback if update fails

---

## Uninstalling

To completely remove VoiceForge:

```bash
sudo bash deploy/uninstall.sh
```

This will:
- Stop and remove the systemd service
- Delete application files
- Remove the service user
- Clean up backups

Note: FFmpeg and Node.js are NOT removed during uninstall.

---

## Configuration

### Environment File

The application configuration is stored in `/opt/voiceforge/.env`:

```bash
# View current configuration
sudo cat /opt/voiceforge/.env

# Edit configuration
sudo nano /opt/voiceforge/.env

# After editing, restart the service
sudo systemctl restart voiceforge
```

### Available Environment Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `NODE_ENV` | `production` | Environment mode |
| `PORT` | `5000` | HTTP server port |
| `SESSION_SECRET` | (auto-generated) | Session encryption key |

---

## Reverse Proxy Setup (Optional)

### Nginx Configuration

```nginx
server {
    listen 80;
    server_name voiceforge.yourdomain.com;

    client_max_body_size 100M;

    location / {
        proxy_pass http://127.0.0.1:5000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
        proxy_read_timeout 300s;
        proxy_send_timeout 300s;
    }
}
```

### Apache Configuration

```apache
<VirtualHost *:80>
    ServerName voiceforge.yourdomain.com

    ProxyPreserveHost On
    ProxyPass / http://127.0.0.1:5000/
    ProxyPassReverse / http://127.0.0.1:5000/

    # WebSocket support
    RewriteEngine On
    RewriteCond %{HTTP:Upgrade} =websocket [NC]
    RewriteRule /(.*)           ws://127.0.0.1:5000/$1 [P,L]
</VirtualHost>
```

---

## Troubleshooting

### Service won't start

Check the logs:
```bash
sudo journalctl -u voiceforge -n 50 --no-pager
```

Common issues:
- Port already in use: Change PORT in .env
- Permission issues: Run `sudo chown -R voiceforge:voiceforge /opt/voiceforge`

### FFmpeg not found

Reinstall FFmpeg:
```bash
# Ubuntu/Debian
sudo apt update && sudo apt install -y ffmpeg

# CentOS/RHEL
sudo yum install -y ffmpeg
```

### Permission denied errors

Fix permissions:
```bash
sudo chown -R voiceforge:voiceforge /opt/voiceforge
sudo chmod 600 /opt/voiceforge/.env
```

### Out of memory

Audio processing can be memory-intensive. Ensure you have at least 1GB RAM available.

---

## Security Recommendations

1. **Use HTTPS**: Set up SSL with Let's Encrypt and use Nginx/Apache as reverse proxy
2. **Firewall**: Only expose necessary ports
3. **Updates**: Regularly update the operating system and application
4. **Monitoring**: Set up log monitoring for suspicious activity

---

## File Locations

| Path | Description |
|------|-------------|
| `/opt/voiceforge/` | Application installation directory |
| `/opt/voiceforge/.env` | Environment configuration |
| `/opt/voiceforge/dist/` | Built application |
| `/etc/systemd/system/voiceforge.service` | Systemd service file |

---

## Support

For issues or questions:
- Check the logs first: `sudo journalctl -u voiceforge -f`
- Ensure all system requirements are met
- Verify FFmpeg is working: `ffmpeg -version`
- Verify Node.js is working: `node -v`
